#!/bin/bash
# Exit codes
STATE_OK=0
STATE_WARNING=1
STATE_CRITICAL=2
STATE_UNKNOWN=3

FILE_TMP=/tmp/xml-search

# Timeout, in seconds
TIMEOUT="240"
TIMEOUT_OPTIONS="-T ${TIMEOUT}"

wget $TIMEOUT_OPTIONS "http://$1/aslHttpInformationRetrieval/GenericSearch?responseType=xml&searchTerms="$2"&allFields=false&count=1" -O $FILE_TMP > /dev/null 2>&1

record=`xmllint --xpath '//Results/RSRecord/field' $FILE_TMP`

rm $FILE_TMP

if [ "$record" != "" ]
	then
		echo "Search ok : $record"
	        exit $STATE_OK
	else
		echo "0 Records found!"
	        exit $STATE_CRITICAL
fi

