#!/bin/bash
# Exit codes
STATE_OK=0
STATE_WARNING=1
STATE_CRITICAL=2
STATE_UNKNOWN=3

FILE_TMP=/tmp/xml-aquamaps

wget --no-check-certificate https://$1/images/report/xml -O $FILE_TMP > /dev/null 2>&1

nimages=`xmllint --xpath '//speciesCount/text()' $FILE_TMP`

rm $FILE_TMP

if [ "$nimages" -gt "0" ]
	then
		echo "Images cached : $nimages"
	        exit $STATE_OK
	else
		echo "0 Images cached!"
	        exit $STATE_CRITICAL
fi

